PlaySound_Pokeball_Break:
    ld hl, wChannelFlags1+7
    set 2, [hl]
    ld a, $01
    ld [wChannelSoundIDs+7], a
    ld de, SFX_Pokeball_Break
    ld c, $03
    	;jr PlaySFXFromRAM ; fall through

; play sound de on channel c
PlaySFXFromRAM:

    	;call InitSFXVariables

    ld h, 00
    ld l, c
    ld bc, $C00E
    add hl, hl
    add hl, bc
    ld [hl], e
    inc hl
    ld [hl], d

    ;xor a
    ;ld bc, $0004
    ;ld hl, $C01E
    ;call FillMemory
    ;ld a, $01
    ;ld bc, $0004
    ;ld hl, $C0BE
    ;call FillMemory
    ;ld a, $e0
    ;ld bc, $0004
    ;ld hl, $C02E
    ;jp FillMemory

        ;xor a
	;ld [wChannelSoundIDs + Ch5], a
	;ld [wChannelSoundIDs + Ch6], a
	;ld [wChannelSoundIDs + Ch7], a
	;ld [wChannelSoundIDs + Ch8], a

    ret

PlaySound_Screech_1:

    ld de, wTileMapBackup2
    ld hl, SFX_Screech_1
    ld bc, SFX_Screech_2 - SFX_Screech_1
    ld a, 3
    call CopyDataFromSRAX

    ld hl, wChannelFlags1+4
    set 2, [hl]
    ld a, $01
    ld [wChannelSoundIDs+4], a
    ld de, wTileMapBackup2	;SFX_Screech_1_Ch5
    ld c, $00
    call PlaySFXFromRAM

    ld hl, wChannelFlags1+5
    set 2, [hl]
    ld a, $01
    ld [wChannelSoundIDs+5], a
    ld de, wTileMapBackup2 + (SFX_Screech_1_Ch6 - SFX_Screech_1_Ch5)	;SFX_Screech_1_Ch6
    ld c, $01
    jp PlaySFXFromRAM

PlaySound_Screech_2:

    ld de, wTileMapBackup2
    ld hl, SFX_Screech_2
    ld bc, SFX_Screech_2_End - SFX_Screech_2
    ld a, 3
    call CopyDataFromSRAX

    ld hl, wChannelFlags1+4
    set 2, [hl]
    ld a, $01
    ld [wChannelSoundIDs+4], a
    ld de, wTileMapBackup2	;SFX_Screech_2_Ch5
    ld c, $00
    call PlaySFXFromRAM

    ld hl, wChannelFlags1+5
    set 2, [hl]
    ld a, $01
    ld [wChannelSoundIDs+5], a
    ld de, wTileMapBackup2 + (SFX_Screech_2_Ch6 - SFX_Screech_2_Ch5)	;SFX_Screech_2_Ch6
    ld c, $01
    jp PlaySFXFromRAM

PlaySound_UrsaringCry:
    xor a
    ld [wFrequencyModifier], a
    ld a, 88
    ld [wTempoModifier], a

    ld hl, Cry_Teddiursa_Ch5
    ld bc, Cry_Teddiursa_End - Cry_Teddiursa_Ch5
    call PlaySound_Cry_Common

    ld de, wPartyMon2	;Cry_Teddiursa_Ch5
    ld c, $00
    call PlaySFXFromRAM
    ld de, wPartyMon2 + (Cry_Teddiursa_Ch6 - Cry_Teddiursa_Ch5)	;Cry_Teddiursa_Ch6
    ld c, $01
    call PlaySFXFromRAM
    ld de, wPartyMon2 + (Cry_Teddiursa_Ch8 - Cry_Teddiursa_Ch5)	;Cry_Teddiursa_Ch8
    ld c, $03
    jp PlaySFXFromRAM

PlaySound_LarvitarCry:
    ld a, 95
    ld [wFrequencyModifier], a
    ld a, 80
    ld [wTempoModifier], a

    ld hl, Cry_Raikou_Ch5
    ld bc, Cry_Raikou_End - Cry_Raikou_Ch5
    call PlaySound_Cry_Common

    ld de, wPartyMon2	;Cry_Raikou_Ch5
    ld c, $00
    call PlaySFXFromRAM
    ld de, wPartyMon2 + (Cry_Raikou_Ch6 - Cry_Raikou_Ch5)	;Cry_Raikou_Ch6
    ld c, $01
    call PlaySFXFromRAM
    ld de, wPartyMon2 + (Cry_Raikou_Ch8 - Cry_Raikou_Ch5)	;Cry_Raikou_Ch8
    ld c, $03
    jp PlaySFXFromRAM

PlaySound_QuagsireCry:
    xor a
    ld [wFrequencyModifier], a
    ld a, 192
    ld [wTempoModifier], a

    ld hl, Cry_Wooper_Ch5
    ld bc, Cry_Wooper_End - Cry_Wooper_Ch5
    call PlaySound_Cry_Common

    ld de, wPartyMon2	;Cry_Wooper_Ch5
    ld c, $00
    call PlaySFXFromRAM
    ld de, wPartyMon2 + (Cry_Wooper_Ch6 - Cry_Wooper_Ch5)	;Cry_Wooper_Ch6
    ld c, $01
    call PlaySFXFromRAM
    ld de, wPartyMon2 + (Cry_Wooper_Ch8 - Cry_Wooper_Ch5)	;Cry_Wooper_Ch8
    ld c, $03
    jp PlaySFXFromRAM

PlaySound_MisdreavusCry:
    xor a
    ld [wFrequencyModifier], a
    ld a, 104
    ld [wTempoModifier], a
    
    ld hl, Cry_Hoothoot_Ch5
    ld bc, Cry_Hoothoot_End - Cry_Hoothoot_Ch5
    call PlaySound_Cry_Common

    ld de, wPartyMon2	;Cry_Hoothoot_Ch5
    ld c, $00
    call PlaySFXFromRAM
    ld de, wPartyMon2 + (Cry_Hoothoot_Ch6 - Cry_Hoothoot_Ch5)	;Cry_Hoothoot_Ch6
    ld c, $01
    call PlaySFXFromRAM
    ld de, wPartyMon2 + (Cry_Hoothoot_Ch8 - Cry_Hoothoot_Ch5)	;Cry_Hoothoot_Ch8
    ld c, $03
    jp PlaySFXFromRAM

PlaySound_Cry_Common:

    ld de, wPartyMon2
    ld a, 3
    call CopyDataFromSRAX

    ld hl, wChannelFlags1+4
    set 2, [hl]
    ld hl, wChannelFlags1+5
    set 2, [hl]
    ld hl, wChannelFlags1+7
    set 2, [hl]
    ld a, SFX_CRY_00
    ld [wChannelSoundIDs+4], a
    ld [wChannelSoundIDs+5], a
    ld [wChannelSoundIDs+7], a




    ret

TextboxEnable:
    ;call SaveScreenTilesToBuffer1
    ;call SaveScreenTilesToBuffer2
    ;call LoadFontTilePatterns
TextboxEnable_NoLoadFont:
    ;ld b, $9c
    ;ld hl, CopyScreenTileBufferToVRAM
    ;call SafeCallHL
    ;ld c, 3
    ;call DelayFrames
    	;xor a
    ;ld a, $5A
    ;ldh [$b0], a
    	;inc a
    ;ldh [$ba], a
    ret

PlayMusicFromRAM:
    ld bc, $0008
    ld de, $C006
    call CopyData
    xor a
    ld bc, $0004
    ld hl, $C016
    call FillMemory
    ld a, $01
    ld bc, $0004
    ld hl, $C0B6
    call FillMemory
    ld a, $e0
    ld bc, $0004
    ld hl, $C026
    jp FillMemory

PlayInventoryMusic:
    ;ld de, $c9e0
    ;ld bc, 512
    ;ld hl, Music_InventoryScreen
    ;ld a, 3
    ;call CopyDataFromSRAX
    ;ld de, $c9d0
    ;ld bc, 8
    ;ld hl, Music_InventoryScreen_Pointers
    ;ld a, 3
    ;call CopyDataFromSRAX
    ;ld hl, $c9d0
    ;jr PlayMusicFromRAM

PlaySongFromHL:
    ld de, $c9d0
    ld bc, 8
    push hl
    ld a, 3
    call CopyDataFromSRAX
    ld de, $c9e0
    pop hl
    ld bc, 8
    add hl, bc
    ld bc, 512
    ld a, 3
    call CopyDataFromSRAX
    ld hl, $c9d0
    jr PlayMusicFromRAM


CompareBCToDE:
    ld a, b
    cp d
    jr nz, .nope
    ld a, c
    cp e
.nope
    ret

CheckROM:
    ld hl, $0000
    ld bc, $3fff
    ld de, $0000
.loop
    ld a, [hl]
    xor d
    ld d, a
    ldi a, [hl]
    add e
    ld e, a
    dec bc
    ld a, c
    or b
    jr nz, .loop
    ld bc, $4DE1
    jp CompareBCToDE

;ConnectionError:
;    ld a, SFX_DENIED
;    call PlaySound
;    call WaitForSoundToFinish
;    ld hl, ConnectionErrorText
;    	;call PrintTextVWF
;    ld hl, ConnectionSimpleMenu
;    	;jp DisplayMenu
;    ret

ConnectionSimpleMenu:
    db $05,$01 ; w, h
    db %00000001 ; [disable screen save][draw textbox][B allowed][R allowed][L allowed][item size][item size][item size]
    db $92,$b3,$a0,$b1,$b3,$50

YesNoSimpleMenu:
    db $03,$02 ; w, h
    db %00100001 ; [disable screen save][draw textbox][B allowed][R allowed][L allowed][item size][item size][item size]
    db $98,$a4,$b2,$4f,$8d,$ae,$50

ConnectionErrorText:
    text "Oopsie woopsie! Couldn't"
    next "connect to the server."
    para "Check your connection,"
    next "then press A to retry."
    done

PlaceStringSimple:
    push bc
    push hl
    ld bc, 20
.nextChar
    ld a, [de]
    inc de
    cp $50
    jr z, .finished
    cp $4f
    jr z, .nextLine
    ld [hli], a
    jr .nextChar
.nextLine
    pop hl
    add hl, bc
    push hl
    jr .nextChar
.finished
    pop hl
    pop bc
    ret

SaveScreenTilesToBuffer2_SaveAll:
    push af
    push bc
    push de
    push hl
    call SaveScreenTilesToBuffer2
    pop hl
    pop de
    pop bc
    pop af
    ret

LoaderTextbox:
    coord hl, 17, 15
    ld bc, $0101
    call TextBoxBorder
    jp UpdateSprites

ClearSpriteData:
    push hl
    ld hl, wSpriteStateData1 + $10
	ld de, wSpriteStateData2 + $10
	xor a
	ld c, $f0
.clearSpriteData
	ld [hli], a
	ld [de], a
	inc e
	dec c
	jr nz, .clearSpriteData
    ld hl, wSpriteStateData1 + $12
	ld de, $0010
	ld c, $0f
.disableAllSprites
	ld [hl], $ff
	add hl, de
	dec c
	jr nz,.disableAllSprites
    pop hl
    ret

; a -> high vram address (aka starting tile id)
; hl -> target
DrawInventoryIcon:
    ld [hli], a
    inc a
    ld [hli], a
    inc a
    push bc
    ld bc, SCREEN_WIDTH - 2
    add hl, bc
    pop bc
    ld [hli], a
    inc a
    ld [hl], a
    ret

; c -> item ID to load, b -> high vram address
LoadInventoryIcon:
    ld a, b
    and $f0
    swap a
    add $80
    ld d, a
    ld a, b
    and $0f
    swap a
    ld e, a
    ld b, 0
    ld hl, $0000
    ld a, 64
    call AddNTimes
    push de
    ld a, 3
    ld de, $cfd0
    push de
    ld bc, 64
    call CopyDataFromSRAX
    pop de
    pop hl
    ld c, 64
    ; fall through to CopyDataDuringHblank
    
; copy c bytes from de to hl during hblank periods
CopyDataDuringHblank:
.waitHblank
    ldh a, [rSTAT]
    and %00000011
    jr nz, .waitHblank
    ld a, [de]
    ld [hli], a
    inc de
    ld a, [de]
    ld [hli], a
    inc de
    dec c
    dec c
    jr z, .done
.waitNoHblank
    ldh a, [rSTAT]
    and %00000011
    jr z, .waitNoHblank
    jr .waitHblank
.done
    ret