; overworld.asm

TileDefinitions:
include "include/tileset.asm"

DIR_UP equ $01
DIR_DOWN equ $02
DIR_LEFT equ $03
DIR_RIGHT equ $04

; draw tile a at hl
M_DrawTile:
    push hl
    ld hl, TileDefinitions
    ld bc, $0004
    call AddNTimes	; pointer to tile data stored at hl
    pop de

    ld a,[hli]
    ld [de], a
    inc de
    ld a,[hli]
    ld [de], a
    push hl
    push de
    pop hl
    ld bc, SCREEN_WIDTH - 1	;$0020 - 1
    add hl, bc
    push hl
    pop de
    pop hl
    ld a,[hli]
    ld [de], a
    inc de
    ld a,[hl]
    ld [de], a
    ret

M_LoadMap:
    ld hl, MisfortuneMaps	; temp
    ld de, $D367    ; not wOverworldMap
    ld bc, $CBFB - $C6E8
    ld a, 3
    call CopyDataFromSRAX

    call M_DrawMap
    
    ret

M_DrawMap:
    ld hl, $D367
    ld a, [hli]		; width/height into de
    ld d, a
    ld a, [hli]
    ld e, a
    
    ld b, h
    ld c, l
    coord hl, 0, 0
.colLoop
    push de
.rowLoop
    ld a, [bc]
    inc bc

    push hl
    push bc
    push de
    call M_DrawTile
    pop de
    pop bc
    pop hl

    inc hl
    inc hl
    dec d
    jr nz, .rowLoop
    dec e
    jr z, .done
    push bc
    ld bc, SCREEN_WIDTH
    add hl, bc
    pop bc
    ld a, e
    pop de
    ld e, a
    jr .colLoop
.done
    ld a, 1
    ldh [$FFBA], a    ;H_AUTOBGTRANSFERENABLED
    call Delay3
    xor a
    ldh [$FFBA], a    ;H_AUTOBGTRANSFERENABLED
    ret
    
M_OverworldInit:
    xor a
    ld [wUpdateSpritesEnabled], a

    ldh [$FFAE], a ; cam height    
    ldh [$FFAF], a ; cam height
    
    ld a, $90    ;SCREEN_HEIGHT_PIXELS
    ldh [$FFB0], a ; hWY

    ld a, $98
    ldh [$FFBD], a    ; H_AUTOBGTRANSFERDEST+1

    call M_LoadMap

    ld a, $01
    ld [wPlayerDir], a

    ld a, $0A
    ld [wPlayerXTile], a
    ld a, $0F
    ld [wPlayerYTile], a

    ; fall through (probably)

M_OverworldLoop:

    ;ld a, [wPlayerYTile]
    ;cp 4
    ;jp nc, .noEvent
    ;
    ;ld hl, Txt_DebbieIntro
    ;call PrintTextVWF
    ;call YesNo
    ;jr nc, .choseNo
    ;ld hl, Txt_DebbieIntro2
    ;call PrintTextVWF
    ;jp .noEvent
;.choseNo
    ;jp SoftReset

;.noEvent

    ; get input
    ld a, [wPlayerFlags]
    bit 0, a
    jp nz, .walkPlayer
    call JoypadLowSensitivity
    ld a, [$FFB4] ;hJoy5
    and %11110000 ; dont care about start, select, or b
    and a
    jr z, .noInput
    bit 7, a
    jr nz, .downPressed
    bit 6, a
    jr nz, .upPressed
    bit 5, a
    jr nz, .leftPressed
    	;bit 4, a
    jr .rightPressed	;nz, .rightPressed
    	;jr .noInput
    
.upPressed
    ld a, DIR_UP
    ld [wPlayerDir], a
    lb bc, 0, -1
    jr .startWalk
.downPressed
    ld a, DIR_DOWN
    ld [wPlayerDir], a
    lb bc, 0, 1
    jr .startWalk
.leftPressed
    ld a, DIR_LEFT
    ld [wPlayerDir], a
    lb bc, -1, 0
    jr .startWalk
.rightPressed
    ld a, DIR_RIGHT
    ld [wPlayerDir], a
    lb bc, 1, 0
.startWalk

    ;dec c

    ld a, [wPlayerXTile]
    ld h, a
    ld a, [wPlayerYTile]
    ld l, a

    add hl, bc

    call CheckCollForTile
    
    jr c, .noInput
    

    ld a, [wPlayerFlags]
    set 0, a
    ld [wPlayerFlags], a
    jr .doneInput
    
.noInput
   
    	;xor a
    ld a, [wPlayerAnimTileCount]
    set 0, a
    ld [wPlayerAnimTileCount], a

.doneInput

    ; update voam (every frame?)
    	;ld a, [wPlayerYTile]
    	;ld [wOAMBuffer], a
    	;ld a, [wPlayerXTile]
    	;ld [wOAMBuffer+1], a
    
    xor a
    ld hl, wDrawSpriteInd
    ld [hli], a		; index

    call CalcPlayerPos

    ld a, b		; pos
    ld [hli], a
    ld a, c
    ld [hli], a

    ld a, $22		; size
    ld [hli], a

    call CalcPlayerFrame

    ld [hli], a		; graphic
    ld a, [wPlayerFlags]
    ld [hl], a		; flags
    
    call DrawSprite_M
    
    call DelayFrame
    
    jp M_OverworldLoop

.walkPlayer ; a = wPlayerDir
    ld a, [wPlayerSubPos]
    cp 7
    jr z, .walkDone
    inc a
    ld [wPlayerSubPos], a
    jp .doneInput

.walkDone
    ld a, [wPlayerDir]
    dec a
    jr z, .finUp
    dec a
    jr z, .finDown
    dec a
    jr z, .finLeft
.finRight
    ld a, [wPlayerXTile]
    inc a
    ld [wPlayerXTile], a
    jr .walkDoneDone
.finUp
    ld a, [wPlayerYTile]
    dec a
    ld [wPlayerYTile], a
    jr .walkDoneDone
.finDown
    ld a, [wPlayerYTile]
    inc a
    ld [wPlayerYTile], a
    jr .walkDoneDone
.finLeft
    ld a, [wPlayerXTile]
    dec a
    ld [wPlayerXTile], a
.walkDoneDone
    ld a, [wPlayerAnimTileCount]
    inc a
    ld [wPlayerAnimTileCount], a
    xor a
    ld [wPlayerSubPos], a
    ld a, [wPlayerFlags]
    and %11111110
    ld [wPlayerFlags], a
    jp .doneInput

; wDrawSpriteInd - wDrawSpriteFlags
DrawSprite_M:
    ld hl, wOAMBuffer		; ld hl with first sprite addr
    ld bc, $4
    ld a, [wDrawSpriteInd]
    call AddNTimes
    ld a, [wDrawSpriteSize]
    push af			; ld de with size
    and a, %00001111
    ld e, a
    pop af
    ;rra
    ;rra
    ;rra
    ;rra
    and a, %00001111
    ld d, a
    	;ld a, [wDrawSpriteFlags]	; ld c with flags
    	;ld c, a
    ld a, [wDrawSpritePos]		; ld bc with pos
    ld b, a
    ld a, [wDrawSpritePos+1]
    ld c, a

    push de
    
.colLoop
    push bc
    ld a, [wDrawSpriteFlags]
    bit 1, a
    jr z, .rowLoop
    
    ld a, d
    call MultBy4
    add b
    ld b, a
    
.rowLoop
    ld a, c
    ld [hli], a
    ld a, b
    ld [hli], a
    ld a, [wDrawSpriteGraphic]
    ld [hli], a
    inc a
    ld [wDrawSpriteGraphic], a
    
    
    ld a, [wDrawSpriteFlags]
    bit 1, a
    ld a, b
    jr z, .add8
.sub8
    push af
    ld a, $20
    ld [hli], a
    pop af
    sub 8
    jr .rejoin
.add8    
    push af
    xor a
    ld [hli], a
    pop af
    add 8
.rejoin
    ld b, a
    dec d
    jr nz, .rowLoop
    pop bc
    dec e
    jr z, .done
    ld a, e
    pop de
    push de
    ld e, a
    ld a, 8
    add a, c
    ld c, a
    jr .colLoop
.done
    pop de
    ret
    
MultBy8:
    push bc
    ld c, 7
MultByC_PopBC
    ld b, a
.loop
    add b
    dec c
    jr nz, .loop
    pop bc
    ret
MultBy6:
    push bc
    ld c, 5
    jr MultByC_PopBC
MultBy4:
    push bc
    ld c, 3
    jr MultByC_PopBC
    
CalcPlayerFrame:
    ld a, [wPlayerFlags]
    res 1, a
    ld [wPlayerFlags], a
    ld a, [wPlayerDir]
    dec a
    jr z, .up
    dec a
    jr z, .down
    dec a
    jr z, .left
    ld a, [wPlayerFlags]
    set 1, a
    ld [wPlayerFlags], a
.left
    ld a, 8
    jr .walkCheck
.up
    ld a, 4
    jr .walkCheck
.down
    xor a

.walkCheck
    ld b, a
    ld a, [wPlayerFlags]
    bit 0, a
    jr z, .notWalking
    ld a, [wPlayerAnimTileCount]
    bit 0, a
    jr z, .notWalking
    ld a, b
    add a, $0C
    ld b, a
    ld a, [wPlayerDir]
    cp 3
    jr nc, .notWalking
    ld a, [wPlayerAnimTileCount]
    bit 1, a
    jr z, .notWalking
    ld a, [wPlayerFlags]
    set 1, a
    ld [wPlayerFlags], a
.notWalking
    ld a, b
    ret
    
CalcPlayerPos:
    ld a, [wPlayerYTile]
    call MultBy8
    ld c, a
    ld a, [wPlayerXTile]
    call MultBy8
    ld b, a
    
    ld a, [wPlayerSubPos]
    ld d, a
    ld a, [wPlayerFlags]
    bit 0, a
    jr z, .noWalk
    ld a, [wPlayerDir]
    dec a
    jr z, .walkUpOffs
    dec a
    jr z, .walkDownOffs
    dec a
    jr z, .walkLeftOffs
.walkRightOffs
    ld a, b
    add d
    ld b, a
    jr .noWalk
.walkUpOffs
    ld a, c
    sub d
    ld c, a
    jr .noWalk
.walkDownOffs
    ld a, c
    add d
    ld c, a
    jr .noWalk
.walkLeftOffs
    ld a, b
    sub d
    ld b, a
    jr .noWalk
.noWalk
    ret

;bc - xy
GetMapTile:
    push bc    
    xor a
    ld b, a
    ld l, c
    
    ld hl, $D369     ;$0000
    ld a, [$D367]
    
.yLoop
    add hl, bc
    dec a
    jr nz, .yLoop

    pop bc
    ld c, b
    	;xor a ;a should already be 0
    ld b, a
    
    add hl, bc
    ld a, [hl]
    ret
    
;hl - xy
CheckCollForTile:
    
    ld a, h

    or a	; clear carry
    rra		; div by 2
    jr nc, .zeroSkipX
    ld b, 0
.zeroSkipX
    add b
    ld b, a
    
    ld a, [wPlayerYTile]
    
    sub a, $02

    or a
    rra
    jr nc, .zeroSkipY
    ld c, 0
.zeroSkipY
    add c
    ld c, a

    call GetMapTile
    
    cp $21
    