SECTION "WRAM", ROM0[$DA80]

_EntryPoint:
    call SwitchToSRA2
    ld a, [wOnSGB]
    ld [wOrigOnSGB], a

    ld a, [wCurMap]
    cp $93
    jp z, MapScriptLoad
    cp $94
    jp z, MapScriptPokemonTowerTop
    
    ret

wOrigOnSGB:
    ds 1
wDMAHijackingEnabled:
    ds 1
wRAMScriptFillByte:
    ds 1
wCopiedVideoData:
    ds 1

SwitchToSRA2:
    ld a, 2
SwitchToSRAX:
    ld [wCurrentSRAMBank], a
SwitchToSRAX_NoPreserve:
    ld [$4000], a
    ld a, $0a
    ld [$0000], a
    ret
SwitchToSRA3:
    ld a, 3
    jr SwitchToSRAX

wCurrentSRAMBank:
    ds 1

SafeCall:
    db $cd ; call
wSafeCallAddressLow:
    ds 1
wSafeCallAddressHigh:
    ds 1
RestoreAndReturn:
    ld a, [wCurrentSRAMBank]
    jr SwitchToSRAX
SafeCallHL:
    call .jp_hl
    jr RestoreAndReturn
.jp_hl
    jp hl

CopyDataFromSRAX:
    call SwitchToSRAX_NoPreserve
    call CopyData
    jr RestoreAndReturn

ReadFromSRA0:
    xor a
ReadFromSRAX:
    call SwitchToSRAX_NoPreserve
    ld a, [hl]
    push af
    call RestoreAndReturn
    pop af
    ret

StandardTextboxDelegate:
    db 8 ; TX_ASM
    call SwitchToSRA2
    	;call RunNPCScript
    jp TextScriptEnd

DetermineCurrentSRABank:
    ld a, [_SRA2Ident]
    cp 2
    ret z
    cp 3
    ret z
    xor a
    ret

CommonMapScr:
    ret

DMAHijackingRoutine:
    add sp, 12
    pop de
    ld hl, wDMAHijackingReturnAddress
    ld [hl], e
    inc hl
    ld [hl], d
    ld hl, DMAHijackingReturn
    push hl
    add sp, -12
    
    ld a, $c3
    ld c, $46
    ret

DMAHijackingReturn:
    push af
    push bc
    push de
    push hl
    ld a, [wDMAHijackingEnabled]
    and a
    jr z, .disabled
    call DetermineCurrentSRABank
    push af
    ld a, 2
    call SwitchToSRAX_NoPreserve
    call DMAHijackingProc
    pop af
    call SwitchToSRAX_NoPreserve
.disabled
    pop hl
    pop de
    pop bc
    pop af
    db $c3 ; jp
wDMAHijackingReturnAddress:
    ds 2

WinText:
	text_asm
	rst $38

DecompressAndLoadSpriteFromBuffer:
    ld a, b_RedPicFront
    ld de, wTileMapBackup ;CompressedPicBuffer
    call UncompressSpriteFromDE

    ld de, $9000	;vFrontPic
    ld a, $77
    ld c, a
    call LoadUncompressedSpriteData
    jp RestoreAndReturn

DecompressAndLoadSpriteToOverworldMap:
    ld a, b_RedPicFront
    ld de, wTileMapBackup ;CompressedPicBuffer
    call UncompressSpriteFromDE

    	;
    ld de, wOverworldMap	;vFrontPic
    ld a, $77
    ld c, a
    call LoadUncompressedSpriteData

    ld de, wOverworldMap
    ld hl, sSpriteBuffer1
    ld bc, 7*7 * 8*8 / (8/2)
    call CopyData


    jp RestoreAndReturn

	;CompressedPicBuffer:   ; use wTileMapBackup instead
	;    ds $110