; maps.asm

TileDefinitions:
include "include/tileset.asm"

MisfortuneMapPtrs:
dw Map00
dw Map01
dw Map02
dw Map03
dw Map04

; draw tile a at hl
M_DrawTile:

    push hl
    push bc
    push de

    call DrawTile_start

    ld a,[hli]
    ld [de], a
    inc de
    ld a,[hli]
    ld [de], a
    push hl
    
    ld hl, SCREEN_WIDTH - 1	;$0020 - 1
    add hl, de
    ld d, h
    ld e, l

    pop hl
    ld a,[hli]
    ld [de], a
    inc de
    ld a,[hl]
    ld [de], a

    pop de
    pop bc
    pop hl

    ret

M_DrawTile_Vert:

    push hl
    push bc
    push de

    call DrawTile_start

    ld c, 4
.vertTileLoop
    ld a,[hli]
    ld [de], a
    inc de
    dec c
    jr nz, .vertTileLoop

    pop de
    pop bc
    pop hl

    ret

; draw half of tile a at hl
DrawTile_start:
    
    push hl
    ld hl, TileDefinitions
    ld bc, $0004
    call AddNTimes	; pointer to tile data stored at hl
    pop de
    ret

M_DrawHalfTile_L:
    push hl
    push bc
    push de

    call DrawTile_start
    jp DrawVHalfTile_pt2  

M_DrawHalfTile_R:
    push hl
    push bc
    push de

    call DrawTile_start
    inc hl
        ; fall thru to DrawVHalfTile_pt2     ;jp DrawVHalfTile_pt2



DrawVHalfTile_pt2:

    ld a,[hli]
    ld [de], a
    inc hl
    push hl

    ld hl, SCREEN_WIDTH
    add hl, de
    ld d, h
    ld e, l

    pop hl
    ld a,[hl]
    ld [de], a
    pop de
    pop bc
    pop hl
    ret

M_DrawHalfTile_U:
    push hl
    push bc
    push de

    call DrawTile_start
    jp DrawHHalfTile

M_DrawHalfTile_D:
    push hl
    push bc
    push de

    call DrawTile_start
    inc hl
    inc hl
    ; fall through to DrawHHalfTile

DrawHHalfTile:

    ld a,[hli]
    ld [de], a
    inc de
    ld a,[hl]
    ld [de], a
    pop de
    pop bc
    pop hl
    ret

    
; load map a
M_LoadMap:
    ld h, 0
    ld l, a
    add hl, hl
    ld bc, MisfortuneMapPtrs
    add hl, bc
    ld a, [hli]
    ld h, [hl]
    ld l, a	; ld hl, [hl]
    				;ld hl, Map01	; temp
    ld de, wMisMapDataStart    ; not wOverworldMap
    ld bc, $CBFB - $C6E8
    ld a, 3
    call CopyDataFromSRAX

    ;lb bc, $00, $00

    xor a
    ld [wEventFlagGeneric], a

    ld a, [wMisMapStartX]
    ld [wPlayerXTile], a
    ld a, [wMisMapStartY]
    ld [wPlayerYTile], a

    call M_DrawMapScreen

    ld hl, wMisLoadScr
    ld a, [hli]
    ld h, [hl]
    ld l, a
    jp hl
    

    	;call M_DrawMapScreen
    	; fall through
    	;ret

;bc - tl map coords
M_DrawMapScreen:	; todone: replace with drawmapscreen

    call CalcCamX
    call CalcCamY

    ld a, [wCameraXTile]
    ld d, a
    or a
    rra
    ld b, a
    ld a, [wCameraYTile]
    ld e, a
    or a
    rra
    ld c, a

    push bc

    ld hl, $9800
    ld bc, $0020
    ld a, e
    call AddNTimes
    ld c, d
    add hl, bc
    ld a, l
    ldh [$FFC3], a    ;[H_VBCOPYBGDEST], a
    ld a, h
    ldh [$FFC4], a    ;[H_VBCOPYBGDEST+1], a
    

    pop bc

    ld hl, wMisMapWidth
    ld a, [hli]		; 00,width into de
    ld e, a
    ld d, $0A
    sub d
    ld d, $00
    ld [wDrawSpriteInd], a	; (map width - scrn width) in wdsi
        
    inc hl
    inc c
.heightLoop
    dec c
    jr z, .endHeightLoop
    add hl, de
    jr .heightLoop
.endHeightLoop

    

    ld e, b
    add hl, de		; hl = topleft tile addr
    
    ld b, h
    ld c, l

    coord hl, 0, 0
    lb de, $0A, $09	; de = screen size
.colLoop
    push de
.rowLoop
    ld a, [bc]
    inc bc

    
    call M_DrawTile
    

    inc hl
    inc hl
    dec d
    jr nz, .rowLoop
    dec e
    jr z, .done
    push bc
    ld bc, SCREEN_WIDTH
    add hl, bc
    pop bc
    
    push hl
    ld a, [wDrawSpriteInd]
    ld l, a
    ld h, 0
    add hl, bc
    ld b, h
    ld c, l
    pop hl

    ld a, e
    pop de
    ld e, a
    jr .colLoop
.done

    ld a, $98
    ldh [$FFBD], a
    ldh [$FFBA], a    ;H_AUTOBGTRANSFERENABLED
    call Delay3
    xor a
    ldh [$FFBA], a    ;H_AUTOBGTRANSFERENABLED

    ret



;bc - xy
GetMapTile:
    push bc    
    xor a
    ld b, a
    		;ld l, c  ;;???????? how fukcing tired was i when i wrote this?????????
    
    ld hl, wMisTileDataStart     ;$0000
    ld a, [wMisMapWidth]
    
    call AddNTimes

    pop bc
    ld c, b
    	;xor a ;a should already be 0
    ld b, a
    
    add hl, bc
    ld a, [hl]
    ret
    
;hl - xy
CheckCollForTile:
    push hl    

    ld a, h
    dec a
    or a	; clear carry
    rra		; div by 2
    ld b, a
    
    ld a, l
    dec a
    or a
    rra
    ld c, a

    push bc
    call GetMapTile
    pop bc
    pop hl

    ld d, a
    
    ld a, $FF
    cp b
    jp z, .set
    cp c
    jp z, .set
    ld a, [wMisMapWidth]
    cp b
    jp z, .set
    ld a, [wMisMapHeight]
    cp c
    jp z, .set
    ld a, d

    cp T_HALFWALL_L
    jr nc, .special
    
    cp T_FLOOR1
    ret

.special
    cp T_WATER
    jr z, .water
    
    cp T_HALFWALL_R
    jr nc, .rightSolid

.leftSolid
    ld a, h
    bit 0, a
    jr z, .unset
    jr .set
.rightSolid
    ld a, h
    bit 0, a
    jr z, .set
    jr .unset
.water
.set
    scf
    ret
.unset
    or a
    ret

; d = destX_8
; e = destY_8
;
; b = srcX_16
; c = srcY_16
RedrawRow:
    

    call RedrawRowColStart

    	;;pop af
    ldh a, [$FFD1]
    bit 0, a
    ld a, e
    jr nz, .drawHalfLoop

    ld d, 10
    
    call DrawTileLoop
    
    ld a, $02
    ldh [$FFD0], a ; hredrawroworcolumnmode
    ret

.drawHalfLoop
    call M_DrawHalfTile_R
    inc hl
    inc bc
    ld a, [bc]

    ld d, 9

    call DrawTileLoop

    call M_DrawHalfTile_L
    
    ld a, $02
    ldh [$FFD0], a ; hredrawroworcolumnmode
    ret

DrawTileLoop:
    call M_DrawTile
    inc hl
    inc hl
    inc bc
    ld a, [bc]
    dec d
    jr nz, DrawTileLoop
    ret

RedrawRowColStart:

    ld a, d
.capLoop
    cp $1F
    jr c, .noCap
    sub $20
    jr .capLoop

.noCap
    ld d, a


    ld a, e
.capLoop2
    cp $1F
    jr c, .noCap2
    sub $20
    jr .capLoop2

.noCap2
    ld e, a


    push bc
    
    ld hl, $9800	;coord hl, 0, 0
    lb bc, $00, $20	;SCREEN_WIDTH

    ld a, e
    call AddNTimes

    ld c, d
    add hl, bc

    ld a, h
    ldh [$FFD2], a ; hredrawroworcolumndest+1
    ld a, l
    ldh [$FFD1], a ; hredrawroworcolumndest

    pop bc
    	;;push af
    call GetMapTile
    ld e, a

    ld b, h
    ld c, l
    ld hl, wRedrawRowOrColumnSrcTiles

    ret


; d = destX_8
; e = destY_8
;
; b = srcX_16
; c = srcY_16
RedrawCol:


    ;ld a, d
    ;and $03
    ;or $98
    ;ld d, a

    ld a, e
    push af
    call RedrawRowColStart

    	;;pop af
    pop af
    bit 0, a
    ld a, [bc]
    jr nz, .drawHalfLoop

    ld d, 9
    
    call DrawTileVertLoop
    
    ld a, $01
    ldh [$FFD0], a ; hredrawroworcolumnmode
    ret
.drawHalfLoop
    
    call M_DrawHalfTile_D
    inc hl
    inc hl

    push hl
    ld a, [wMisMapWidth] ;[$D367]
    ld l, a
    ld h, 0
    add bc
    ld b, h
    ld c, l
    pop hl

    ld a, [bc]

    ld d, 8

    call DrawTileVertLoop

    call M_DrawHalfTile_U
    
    ld a, $01
    ldh [$FFD0], a ; hredrawroworcolumnmode
    ret

DrawTileVertLoop:
    call M_DrawTile_Vert
    inc hl
    inc hl
    inc hl
    inc hl

    push hl
    ld a, [wMisMapWidth];[$D367]
    ld l, a
    ld h, 0
    add bc
    ld b, h
    ld c, l
    pop hl

    ld a, [bc]
    dec d
    jr nz, DrawTileVertLoop
    ret
