import java.io.*;
import static java.nio.file.StandardCopyOption.REPLACE_EXISTING;
import java.nio.file.Files;
import java.util.*;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.awt.Graphics;
import java.io.*;
import java.util.*;

public class Corruptor2 {
   public static CorrPanel CorrPnl;
   public static void main(String[] args) throws FileNotFoundException {
      JFrame frame = new JFrame("Cave Story Corruptor");
      frame.setSize(250, 450);
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      CorrPnl = new CorrPanel();
      frame.setContentPane(CorrPnl);
      frame.setVisible(true);
   }
}

class ScrollButton extends JButton{
   public int set;
   String bname;
   String[] opt;
   public ScrollButton(String name, ActionListener lst, String[] gopt, int dflt){
      super("Loading...");
      setFont(new Font("Courier New", Font.PLAIN, 12));
      addActionListener(lst);
      bname = name;
      set = dflt;
      opt = gopt;
      updateLabel();
   }
   public void updateLabel(){
      setLabel(bname + opt[set]);
   }
   public void addSet(){
      set = (set + 1) % opt.length;
   }
   public int getSet(){
      return set;
   }
}

class ToggleButton extends JButton{
   public boolean set;
   String bname;
   public ToggleButton(String name, ActionListener lst, boolean dflt){
      super("Loading...");
      setFont(new Font("Courier New", Font.PLAIN, 12));
      addActionListener(lst);
      bname = name;
      set = dflt;
      updateLabel();
   }
   public void updateLabel(){
      if(set){
         setLabel(bname + "ON ");
      } else {
         setLabel(bname + "OFF");
      }
   }
   public void flipSet(){
      set = !set;
   }
   public boolean getSet(){
      return set;
   }
}

class LstSlide implements ChangeListener {
   public void stateChanged(ChangeEvent e) {
      JSlider source = (JSlider)e.getSource();
      CorrPanel.setIntensity((int)source.getValue());
      
   }
}

class LstToggle implements ActionListener {
   public void actionPerformed(ActionEvent e){
      ((ToggleButton)e.getSource()).flipSet();
      ((ToggleButton)e.getSource()).updateLabel();
   }
}

class LstScroll implements ActionListener {
   public void actionPerformed(ActionEvent e){
      ((ScrollButton)e.getSource()).addSet();
      ((ScrollButton)e.getSource()).updateLabel();
   }
}

class LstCorrupt implements ActionListener {
   public void actionPerformed(ActionEvent e){
      CorrPanel.corrcall();
   }
}

class SliderPanel extends JPanel{
   public static JSlider slider;
   public static JLabel label;
   public SliderPanel(){
      setLayout(new GridLayout(2, 1));
      label = new JLabel("Intensity");
      slider = new JSlider(JSlider.HORIZONTAL, 0, 100, 100);
      slider.setMajorTickSpacing(25);
      slider.setMinorTickSpacing(5);
      slider.setPaintTicks(true);
      slider.addChangeListener(new LstSlide());
      add(label, 0, 0);
      add(slider, 0, 1);
      updateLabel(100);
   }
   public void updateLabel(int num){
      label.setText("          Intensity: " + num + "%");
   }
}

class CorrPanel extends JPanel{
   JLabel logo;
   public static ToggleButton btntsc;
   public static ToggleButton btnnpc;
   public static ToggleButton btnprt;
   public static ToggleButton btnbak;
   public static ScrollButton btnmap;
   public static int intensity = 100;
   public static SliderPanel sldpnl = new SliderPanel();
   String[] opts = {" TOGETHER", " SEPARATE", "PXEs ONLY", "MAPS ONLY", "      OFF"};
   public JButton btncor;
   public CorrPanel(){
      setLayout(new GridLayout(8, 1));
      logo = new JLabel(new ImageIcon("in/logo.png"));
      btntsc = new ToggleButton("Corrupt TSC:        ", new LstToggle(), true);
      btnnpc = new ToggleButton("Corrupt NPCs:       ", new LstToggle(), true);
      btnprt = new ToggleButton("Corrupt Tiles:      ", new LstToggle(), true);
      btnbak = new ToggleButton("Corrupt BKs:        ", new LstToggle(), true);
      btnmap = new ScrollButton("Corrupt Maps: ", new LstScroll(), opts, 4);
      btncor = new JButton("CORRUPT");
      btncor.addActionListener(new LstCorrupt());
      btncor.setFont(new Font("Courier New", Font.BOLD, 22));
      add(logo, 0, 0);
      add(btntsc, 0, 1);
      add(btnnpc, 0, 2);
      add(btnprt, 0, 3);
      add(btnbak, 0, 4);
      add(btnmap, 0, 5);
      add(sldpnl);
      add(btncor, 0, 7);
   }
   
   public static void corrcall(){
      try {
         Files.copy(new File("in/title.pbm").toPath(), new File("out/data/Title.pbm").toPath(), REPLACE_EXISTING);
      } catch(IOException e){
         e.printStackTrace();
      }
      corrupt("tsc/", "data/Stage/", btntsc.getSet(), false, intensity);
      corrupt("npc/", "data/Npc/", btnnpc.getSet(), false, intensity);
      corrupt("prt/", "data/Stage/", btnprt.getSet(), false, intensity);
      corrupt("bak/", "data/", btnbak.getSet(), false, intensity);
      if(btnmap.getSet() == 0){
         corrupt("pxm/", "data/Stage/", true, true, intensity);
      } else if(btnmap.getSet() == 1){
         corrupt("pxe/", "data/Stage/", true, false, intensity);
         corrupt("pxm/", "data/Stage/", true, false, intensity);
      } else if(btnmap.getSet() == 2){
         corrupt("pxe/", "data/Stage/", true, false, intensity);
      } else if(btnmap.getSet() == 3){
         corrupt("pxm/", "data/Stage/", true, false, intensity);
      } else {
         corrupt("pxm/", "data/Stage/", false, true, intensity);
      }
   }
   
   public static void setIntensity(int amount){
      intensity = amount;
      sldpnl.updateLabel(intensity);
   }
   
   public static void corrupt(String path1, String path2, boolean really, boolean tmap, int inten){
      File[] listOfFiles = new File("in/" + path1).listFiles();
      
      ArrayList<String> names = new ArrayList<String>();
      ArrayList<String> namesbk = new ArrayList<String>();

      for(int i=0; i<listOfFiles.length; i++){
         //System.out.print("- ");
         if(!listOfFiles[i].getName().equals(".DS_Store")){
            //System.out.println(listOfFiles[i].getName());
            names.add(listOfFiles[i].getName());
            namesbk.add(listOfFiles[i].getName());
         }
      }
      if(really && Math.random()*100 <= inten){
         for(int i=0; i<names.size(); i++){
            int swap = (int)(Math.random()*names.size() - i) + i;
            String temp = names.get(i);
            names.set(i, names.get(swap));
            names.set(swap, temp);
         }
      }
      for(int i=0; i<names.size(); i++){
         try{
            if(tmap){
               if(new File("in/pxe/" + namesbk.get(i).substring(0, namesbk.get(i).length() - 4) + ".pxe").exists()){
                  Files.copy(new File("in/pxe/" + namesbk.get(i).substring(0, namesbk.get(i).length() - 4) + ".pxe").toPath(), new File("out/" + path2 + names.get(i).substring(0, names.get(i).length() - 4) + ".pxe").toPath(), REPLACE_EXISTING);
               }
               if(new File("in/pxm/" + namesbk.get(i).substring(0, namesbk.get(i).length() - 4) + ".pxm").exists()){
                  Files.copy(new File("in/pxm/" + namesbk.get(i).substring(0, namesbk.get(i).length() - 4) + ".pxm").toPath(), new File("out/" + path2 + names.get(i).substring(0, names.get(i).length() - 4) + ".pxm").toPath(), REPLACE_EXISTING);
               }
            } else {
               Files.copy(new File("in/" + path1 + namesbk.get(i)).toPath(), new File("out/" + path2 + names.get(i)).toPath(), REPLACE_EXISTING);
            }
         } catch(IOException e){
            e.printStackTrace();
         }
      }
   }
}